﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using KoloryWPF.Model;

namespace TestyJednostkowe.Model
{
    [TestClass]
    public class KolorTesty
    {
        [TestMethod]
        public void TestKonstruktoraIWłasności()
        {
            //przygotowania (assert)
            byte r = 0;
            byte g = 128;
            byte b = 255;

            //działanie (act)
            Kolor kolor = new Kolor(r, g, b);

            //weryfikacja (assert)
            Assert.AreEqual(r, kolor.R, "Niezgodność dotycząca własności R");
            Assert.AreEqual(g, kolor.G, "Niezgodność dotycząca własności G");
            Assert.AreEqual(b, kolor.B, "Niezgodność dotycząca własności B");
        }

        /*
        [TestMethod]
        public void TestKonstruktoraIWłasności_WszystkieWartości()
        {
            for (byte r = 0; r <= 255; r++)
                for (byte g = 0; g <= 255; g++)
                    for (byte b = 0; b <= 255; b++)
                    {
                        Kolor kolor = new Kolor(r, g, b);

                        Assert.AreEqual(r, kolor.R, "Niezgodność dotycząca własności R");
                        Assert.AreEqual(g, kolor.G, "Niezgodność dotycząca własności G");
                        Assert.AreEqual(b, kolor.B, "Niezgodność dotycząca własności B");
                    }
        }
        */
          
        private const int liczbaPowtórzeń = 100000;
        private Random rnd = new Random();

        [TestMethod]
        public void TestKonstruktoraIWłasności_LosoweWartości()
        {
            byte[] losoweWartościSkładowychKoloru = new byte[3 * liczbaPowtórzeń];
            rnd.NextBytes(losoweWartościSkładowychKoloru);

            for (int i = 0; i < liczbaPowtórzeń; i++)
            {
                byte r = losoweWartościSkładowychKoloru[3 * i];
                byte g = losoweWartościSkładowychKoloru[3 * i + 1];
                byte b = losoweWartościSkładowychKoloru[3 * i + 2];

                Kolor kolor = new Kolor(r, g, b);

                //weryfikacja (assert)
                Assert.AreEqual(r, kolor.R, "Niezgodność dotycząca własności R");
                Assert.AreEqual(g, kolor.G, "Niezgodność dotycząca własności G");
                Assert.AreEqual(b, kolor.B, "Niezgodność dotycząca własności B");
            }
        }

        [TestMethod]
        public void TestKonstruktora()
        {
            byte r = 0;
            byte g = 128;
            byte b = 255;

            Kolor kolor = new Kolor(r, g, b);

            PrivateObject po = new PrivateObject(kolor);
            byte kolor_r = (byte)po.GetField("r");
            byte kolor_g = (byte)po.GetField("g");
            byte kolor_b = (byte)po.GetField("b");
            Assert.AreEqual(r, kolor_r, "Niezgodność dotycząca pola r");
            Assert.AreEqual(g, kolor_g, "Niezgodność dotycząca pola g");
            Assert.AreEqual(b, kolor_b, "Niezgodność dotycząca pola b");            
        }

        [TestMethod]
        public void TestWłasności()
        {
            byte r = 0;
            byte g = 128;
            byte b = 255;
            
            Kolor kolor = new Kolor(0, 0, 0);
            PrivateObject po = new PrivateObject(kolor);
            po.SetField("r", r);
            po.SetField("g", g);
            po.SetField("b", b);
            
            Assert.AreEqual(r, kolor.R, "Niezgodność dotycząca własności R");
            Assert.AreEqual(g, kolor.G, "Niezgodność dotycząca własności G");
            Assert.AreEqual(b, kolor.B, "Niezgodność dotycząca własności B");
        }
    }
}
